/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.level.block.entity;

import fuzs.eternalnether.init.ModBlocks;
import fuzs.eternalnether.init.ModEntityTypes;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinPrisoner;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4140;
import net.minecraft.class_9381;
import org.apache.commons.lang3.mutable.MutableInt;

public class NetheriteBellBlockEntity
extends class_2586 {
    private static final int DURATION = 50;
    private static final int GLOW_DURATION = 300;
    private static final int MIN_TICKS_BETWEEN_SEARCHES = 60;
    private static final int MAX_RESONATION_TICKS = 40;
    private static final int TICKS_BEFORE_RESONATION = 5;
    private static final int SEARCH_RADIUS = 48;
    private static final int HEAR_BELL_RADIUS = 32;
    private static final int HIGHLIGHT_PIGLIN_PRISONERS_RADIUS = 48;
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public class_2350 clickDirection;
    private List<class_1309> nearbyEntities;
    private boolean resonating;
    private int resonationTicks;

    public NetheriteBellBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlocks.NETHERITE_BELL_BLOCK_ENTITY_TYPE.comp_349(), blockPos, blockState);
    }

    public boolean method_11004(int id, int type) {
        if (id == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = class_2350.method_10143((int)type);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.method_11004(id, type);
    }

    public static void clientTick(class_1937 level, class_2338 blockPos, class_2680 blockState, NetheriteBellBlockEntity blockEntity) {
        NetheriteBellBlockEntity.tick(level, blockPos, blockState, blockEntity, NetheriteBellBlockEntity::showBellParticles);
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, NetheriteBellBlockEntity blockEntity) {
        NetheriteBellBlockEntity.tick(level, blockPos, blockState, blockEntity, NetheriteBellBlockEntity::completePiglinPrisoneRescue);
    }

    private static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, NetheriteBellBlockEntity blockEntity, ResonationEndAction endAction) {
        if (blockEntity.shaking) {
            ++blockEntity.ticks;
        }
        if (blockEntity.ticks >= 50) {
            blockEntity.shaking = false;
            blockEntity.ticks = 0;
        }
        if (blockEntity.ticks >= 5 && blockEntity.resonationTicks == 0 && NetheriteBellBlockEntity.arePiglinPrisonersNearby(blockPos, blockEntity.nearbyEntities)) {
            blockEntity.resonating = true;
            level.method_8396(null, blockPos, class_3417.field_19167, class_3419.field_15245, 1.5f, 0.8f);
        }
        if (blockEntity.resonating) {
            if (blockEntity.resonationTicks < 40) {
                ++blockEntity.resonationTicks;
            } else {
                endAction.run(level, blockPos, blockEntity.nearbyEntities);
                blockEntity.resonating = false;
            }
        }
    }

    public void onHit(class_2350 direction) {
        class_2338 blockPos = this.method_11016();
        this.clickDirection = direction;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.field_11863.method_8427(blockPos, this.method_11010().method_26204(), 1, direction.method_10146());
    }

    private void updateEntities() {
        class_2338 blockpos = this.method_11016();
        if (this.field_11863.method_8510() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.field_11863.method_8510();
            class_238 aabb = new class_238(blockpos).method_1014(48.0);
            this.nearbyEntities = this.field_11863.method_18467(class_1309.class, aabb);
        }
        if (!this.field_11863.field_9236) {
            for (class_1309 livingentity : this.nearbyEntities) {
                if (!NetheriteBellBlockEntity.isLivingEntityWithinRange(blockpos, livingentity, 32)) continue;
                livingentity.method_18868().method_18878(class_4140.field_19009, (Object)this.field_11863.method_8510());
            }
        }
    }

    private static boolean arePiglinPrisonersNearby(class_2338 blockPos, List<class_1309> piglinPrisoners) {
        for (class_1309 livingentity : piglinPrisoners) {
            if (!NetheriteBellBlockEntity.isRescuedPiglinPrisonerWithinRange(blockPos, livingentity, 32)) continue;
            return true;
        }
        return false;
    }

    private static void completePiglinPrisoneRescue(class_1937 level, class_2338 blockPos, List<class_1309> piglinPrisoners) {
        piglinPrisoners.stream().filter(piglinPrisoner -> NetheriteBellBlockEntity.isRescuedPiglinPrisonerWithinRange(blockPos, piglinPrisoner, 48)).forEach(NetheriteBellBlockEntity::rescue);
    }

    private static void showBellParticles(class_1937 level, class_2338 blockPos, List<class_1309> piglinPrisoners) {
        MutableInt mutableint = new MutableInt(16700985);
        int i = (int)piglinPrisoners.stream().filter(livingEntity -> blockPos.method_19769((class_2374)livingEntity.method_19538(), 48.0)).count();
        piglinPrisoners.stream().filter(livingEntity -> NetheriteBellBlockEntity.isRescuedPiglinPrisonerWithinRange(blockPos, livingEntity, 48)).forEach(livingEntity -> {
            double d0 = Math.sqrt((livingEntity.method_23317() - (double)blockPos.method_10263()) * (livingEntity.method_23317() - (double)blockPos.method_10263()) + (livingEntity.method_23321() - (double)blockPos.method_10260()) * (livingEntity.method_23321() - (double)blockPos.method_10260()));
            double d1 = (double)((float)blockPos.method_10263() + 0.5f) + 1.0 / d0 * (livingEntity.method_23317() - (double)blockPos.method_10263());
            double d2 = (double)((float)blockPos.method_10260() + 0.5f) + 1.0 / d0 * (livingEntity.method_23321() - (double)blockPos.method_10260());
            int j = class_3532.method_15340((int)((i - 21) / -2), (int)3, (int)15);
            for (int k = 0; k < j; ++k) {
                int l = mutableint.addAndGet(5);
                level.method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)l), d1, (double)((float)blockPos.method_10264() + 0.5f), d2, 0.0, 0.0, 0.0);
            }
        });
    }

    private static boolean isLivingEntityWithinRange(class_2338 blockPos, class_1309 livingentity, int radius) {
        return livingentity.method_5805() && !livingentity.method_31481() && blockPos.method_19769((class_2374)livingentity.method_19538(), (double)radius);
    }

    private static boolean isRescuedPiglinPrisonerWithinRange(class_2338 blockPos, class_1309 livingEntity, int radius) {
        return NetheriteBellBlockEntity.isLivingEntityWithinRange(blockPos, livingEntity, radius) && livingEntity.method_5864() == ModEntityTypes.PIGLIN_PRISONER.comp_349() && ((PiglinPrisoner)livingEntity).getTempter() != null;
    }

    private static void rescue(class_1309 entity) {
        NetheriteBellBlockEntity.glow(entity);
        NetheriteBellBlockEntity.broadcastRescue(entity);
    }

    private static void glow(class_1309 entity) {
        entity.method_6092(new class_1293(class_1294.field_5912, 300));
    }

    private static void broadcastRescue(class_1309 livingEntity) {
        ((PiglinPrisoner)livingEntity).rescue();
    }

    @FunctionalInterface
    static interface ResonationEndAction {
        public void run(class_1937 var1, class_2338 var2, List<class_1309> var3);
    }
}

